//canvas setup

const gamescreen = document.querySelector('.gamescreen');
const gs_ctx = gamescreen.getContext('2d');
const height = gamescreen.height = window.innerHeight*0.9;
/*const width = */gamescreen.width = height;
let tileD = height*(1/12);
let centrecord = height*0.5-tileD*0.5

//load in images
//sprites
//playersprite setup
let playerS = new Image();
playerS.src = './assets/orange_rectangle_person.png';
let playerSdata = {"xcoord":0, "ycoord":0, "sprite":0, "lastmoved":Date.now(), "xmoving":0, "ymoving":0};
let playerPOSdata = {"xcoord":6, "ycoord":6}

//tiles
//notfoundtile
let notfoundT = new Image();
notfoundT.src = './assets/notfoundtile.png'
//basicgrass(0)
let basicgrassT = new Image();
basicgrassT.src = './assets/0_basicgrass.png'
//dirtpath(1)
let dirtpathT = new Image();
dirtpathT.src = './assets/1_dirtpath.png';
//calmwater(2)
let calmwaterT = new Image();
calmwaterT.src = './assets/2_calmwater.png';
//???(4)
//flowers(5)
let flowersT = new Image();
flowersT.src = './assets/5_flowers.png';

//drawing
draw();

function drawsprite(){
    gs_ctx.drawImage(playerS, playerSdata["sprite"]*500, 0, 500, 500, centrecord, centrecord, tileD*0.9, tileD*0.9);
}

function drawmap() {
    for(let y = 0; y < mainmap.length; ++y) {
        for (let x = 0; x < mainmap[0].length; ++x) {
            let blockXY = [x*tileD-playerSdata["xcoord"]+tileD*(playerSdata["xmoving"]/10)-tileD*0.5,
                           y*tileD-playerSdata["ycoord"]+tileD*(playerSdata["ymoving"]/10)-tileD*0.5]
            switch (mainmap[y][x]) {
                case 0:
                    gs_ctx.drawImage(basicgrassT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                case 1:
                    gs_ctx.drawImage(dirtpathT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                case 2:
                    gs_ctx.drawImage(calmwaterT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                case 5:
                    gs_ctx.drawImage(flowersT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
                default:
                    gs_ctx.drawImage(notfoundT, 0, 0, 500, 500, blockXY[0], blockXY[1], tileD, tileD);
                    break;
            }
        }
    }
    if (playerSdata["xmoving"] > 0) playerSdata["xmoving"] -= 1;
    if (playerSdata["xmoving"] < 0) playerSdata["xmoving"] += 1;
    if (playerSdata["ymoving"] > 0) playerSdata["ymoving"] -= 1;
    if (playerSdata["ymoving"] < 0) playerSdata["ymoving"] += 1;
}

function draw() {
    drawmap();
    drawsprite();
    window.requestAnimationFrame(draw);
    //show coordinates
    document.getElementById("bottomtextbox").innerText = JSON.stringify(playerSdata) + "\n"
                                                                  + JSON.stringify(playerPOSdata) + "\n"
                                                                  + collisioncheck().toString();
}

//collision handling (returns "R", "L", "U", "D", "N" if collision to right, left, up, down & no collision respectively
function collisioncheck() {
    let x = playerPOSdata["xcoord"]; let y = playerPOSdata["ycoord"];
    let collisionlist = [];
    if (collision_tiles.includes(mainmap[y][x + 1])) collisionlist.push("R");
    if (collision_tiles.includes(mainmap[y][x - 1])) collisionlist.push("L");
    if (collision_tiles.includes(mainmap[y - 1][x])) collisionlist.push("U");
    if (collision_tiles.includes(mainmap[y + 1][x])) collisionlist.push("D");
    if (collisionlist.length === 0) collisionlist.push("N");
    return collisionlist
}


//keyboard stuff
function keyboardstuff(keyevent) {
    keyboard_to_movement(keyevent);
}

//keyboard movement controls
function keyboard_to_movement(keyevent) {
    if (keyevent.key === "ArrowRight"
        && playerPOSdata["xcoord"] < mainmap[0].length - 7
        && playerSdata["xmoving"] === 0
        && !collisioncheck().includes("R")) {
        playerSdata["xcoord"] += tileD;
        playerPOSdata["xcoord"] += 1;
        playerSdata["xmoving"] = 9;
        playerSdata["sprite"] = 0;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowLeft"
        && playerPOSdata["xcoord"] > 6
        && playerSdata["xmoving"] === 0
        && !collisioncheck().includes("L")) {
        playerSdata["xcoord"] -= tileD;
        playerPOSdata["xcoord"] -= 1;
        playerSdata["xmoving"] = -9;
        playerSdata["sprite"] = 1;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowUp"
        && playerPOSdata["ycoord"] > 6
        && playerSdata["ymoving"] === 0
        && !collisioncheck().includes("U")) {
        playerSdata["ycoord"] -= tileD;
        playerPOSdata["ycoord"] -= 1;
        playerSdata["ymoving"] = -9;
        playerSdata["sprite"] = 2;
        playerSdata["lastmoved"] = Date.now();
    }
    if (keyevent.key === "ArrowDown"
        && playerPOSdata["ycoord"] < mainmap.length - 7
        && playerSdata["ymoving"] === 0
        && !(collisioncheck().includes("D"))) {
        playerSdata["ycoord"] += tileD;
        playerPOSdata["ycoord"] += 1;
        playerSdata["ymoving"] = 9;
        playerSdata["sprite"] = 3;
        playerSdata["lastmoved"] = Date.now();
    }
}

window.addEventListener("keydown", function(key){keyboardstuff(key)})